%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      PlotResults.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    Plots the metrics for the different sensors
%--------------------------------------------------------------------------

close all; clear all; clc;
Version = 'R01';        % This is the original simulation using a D65
                        % light source and default pixel settings


% These booleans enable or disable the plotting for each number of sensors                        
PlotSensor3 = true;
PlotSensor4 = true;
PlotSensor5 = true;
PlotSensor6 = true;
PlotSensor7 = true;

% Enables plotting of the 90% regions for delta-E and MTF-50
PlotBounds = false;

mean_all = [];  % Save all the means
freq_all = [];  % Save all the frequencies
color_all = []; % Save all the colors
noise_all = []; % Save all the noise data

% Load in all the sensor data
%---------------------------------------------

% Load in the results for 3 sensors
if(PlotSensor3) 
    load Results_3.mat;
    data3 = Results3(:,end-2:end);
    color3 = data3(:,1);
    freq3 = data3(:,2);
    noise3 = data3(:,3);
   
    mean3 = mean(data3)';     % Calculate the sample mean
    
    % Calculate 90% regions for delta-E and MTF50
    BoundMin = 0.05*size(data3,1) + 1;
    BoundMax = 0.95*size(data3,1);
    
    [DeltaE_Sort3, DeltaE_SortIdx3] = sort(data3(:,1));
    DeltaE_Bounds3 = [DeltaE_Sort3(BoundMin), DeltaE_Sort3(BoundMax)];
    [MTF_Sort3, MTF_SortIdx3] = sort(data3(:,2));
    MTF_Bounds3 = [MTF_Sort3(BoundMin), MTF_Sort3(BoundMax)];
    
    disp('3 sensor 90% intervals:');
    DeltaE_Bounds3
    MTF_Bounds3
    mean3
    
    mean_all = [mean_all mean3];
    freq_all = [freq_all ; freq3];
    color_all = [color_all ; color3];
    noise_all = [noise_all ; noise3];
end

% Load in the results for 4 sensors
if(PlotSensor4)
    load Results_4.mat;
    data4 = Results4(:,end-2:end);
    color4 = data4(:,1);
    freq4 = data4(:,2);
    noise4 = data4(:,3);
    
    mean4 = mean(data4)';    % Calculate the sample mean
    
    % Calculate 90% regions for delta-E and MTF50
    BoundMin = 0.05*size(data4,1) + 1;
    BoundMax = 0.95*size(data4,1);
    
    [DeltaE_Sort4, DeltaE_SortIdx4] = sort(data4(:,1));
    DeltaE_Bounds4 = [DeltaE_Sort4(BoundMin), DeltaE_Sort4(BoundMax)];
    [MTF_Sort4, MTF_SortIdx4] = sort(data4(:,2));
    MTF_Bounds4 = [MTF_Sort4(BoundMin), MTF_Sort4(BoundMax)];
    
    disp('4 sensor 90% intervals:');
    DeltaE_Bounds4
    MTF_Bounds4
    mean4
    
    mean_all = [mean_all mean4];
    freq_all = [freq_all ; freq4];
    color_all = [color_all ; color4];
    noise_all = [noise_all ; noise4];
end

% Load in the results for 5 sensors
if(PlotSensor5)
    load Results_5.mat
    data5 = Results5(:,end-2:end);
    color5 = data5(:,1);
    freq5 = data5(:,2);
    noise5 = data5(:,3);
    
    mean5 = mean(data5)';    % Calculate the sample mean
    
    % Calculate 90% regions for delta-E and MTF50
    BoundMin = 0.05*size(data5,1) + 1;
    BoundMax = 0.95*size(data5,1);
    
    [DeltaE_Sort5, DeltaE_SortIdx5] = sort(data5(:,1));
    DeltaE_Bounds5 = [DeltaE_Sort5(BoundMin), DeltaE_Sort5(BoundMax)];
    [MTF_Sort5, MTF_SortIdx5] = sort(data5(:,2));
    MTF_Bounds5 = [MTF_Sort5(BoundMin), MTF_Sort5(BoundMax)];
    
    disp('5 sensor 90% intervals:');
    DeltaE_Bounds5
    MTF_Bounds5
    mean5
    
    mean_all = [mean_all mean5];
    freq_all = [freq_all ; freq5];
    color_all = [color_all ; color5];
end

% Load in the results for 6 sensors
if(PlotSensor6)
    load Results_6.mat
    data6 = Results6(:,end-2:end);
    color6 = data6(:,1);
    freq6 = data6(:,2);
    noise6 = data6(:,3);
    
    mean6 = mean(data6)';    % Calculate the sample mean
    
    % Calculate 90% regions for delta-E and MTF50
    BoundMin = 0.05*size(data6,1) + 1;
    BoundMax = 0.95*size(data6,1);
    
    [DeltaE_Sort6, DeltaE_SortIdx6] = sort(data6(:,1));
    DeltaE_Bounds6 = [DeltaE_Sort6(BoundMin), DeltaE_Sort6(BoundMax)];
    [MTF_Sort6, MTF_SortIdx6] = sort(data6(:,2));
    MTF_Bounds6 = [MTF_Sort6(BoundMin), MTF_Sort6(BoundMax)];
    
    disp('6 sensor 90% intervals:');
    DeltaE_Bounds6
    MTF_Bounds6
    mean6
    
    mean_all = [mean_all mean6];
    freq_all = [freq_all ; freq6];
    color_all = [color_all ; color6];
end

% Load in the results for 7 sensors
if(PlotSensor7)
    load Results_7.mat
    data7 = Results7(:,end-2:end);
    color7 = data7(:,1);
    freq7 = data7(:,2);
    noise7 = data7(:,3);
    
    mean7 = mean(data7)';    % Calculate the sample mean
    
    % Calculate 90% regions for delta-E and MTF50
    BoundMin = 0.05*size(data7,1) + 1;
    BoundMax = 0.95*size(data7,1);
    
    [DeltaE_Sort7, DeltaE_SortIdx7] = sort(data7(:,1));
    DeltaE_Bounds7 = [DeltaE_Sort7(BoundMin), DeltaE_Sort7(BoundMax)];
    [MTF_Sort7, MTF_SortIdx7] = sort(data7(:,2));
    MTF_Bounds7 = [MTF_Sort7(BoundMin), MTF_Sort7(BoundMax)];
    
    disp('7 sensor 90% intervals:');
    DeltaE_Bounds7
    MTF_Bounds7
    mean7
    
    mean_all = [mean_all mean7];
    freq_all = [freq_all ; freq7];
    color_all = [color_all ; color7];
end

% Plot the mean values for the different sensors
%-----------------------------------------------------

figure;
MeanLegends = {};
if(PlotSensor3)
    plot(mean3(2), mean3(1),'bs','MarkerFaceColor','b','MarkerSize',10); hold on; 
    MeanLegends = {MeanLegends{:},'Mean: 3 colors'};
end
if(PlotSensor4)
    plot(mean4(2), mean4(1),'gs','MarkerFaceColor','g','MarkerSize',10); hold on; 
    MeanLegends = {MeanLegends{:},'Mean: 4 colors'};
end
if(PlotSensor5)
    plot(mean5(2), mean5(1),'rs','MarkerFaceColor','r','MarkerSize',10); hold on; 
    MeanLegends = {MeanLegends{:},'Mean: 5 colors'};
end
if(PlotSensor6)
    plot(mean6(2), mean6(1),'cs','MarkerFaceColor','c','MarkerSize',10); hold on; 
    MeanLegends = {MeanLegends{:},'Mean: 6 colors'};
end    
if(PlotSensor7)
    plot(mean7(2), mean7(1),'ks','MarkerFaceColor','k','MarkerSize',10); hold on; 
    MeanLegends = {MeanLegends{:},'Mean: 7 colors'};
end

% Get the minimum and maximum values for the axis limits
MinX = 0.9*min(mean_all(2,:));
MaxX = 1.1*max(mean_all(2,:));
MinY = 0.9*min(mean_all(1,:));
MaxY = 1.1*max(mean_all(1,:));

axis([MinX MaxX MinY MaxY]);
legend(MeanLegends, 'Location','NorthWest','FontSize',12);
title('\bfMean values for different color sensors','FontSize',13);
xlabel('MTF-50','FontSize',12);
ylabel('Average \Delta E','FontSize',12);
set(gca,'FontSize',12);
grid on;

% Save the plot
saveas(gcf, ['./Images/Mean_values_' Version '.eps'],'epsc2');
saveas(gcf, ['./Images/Mean_values_' Version '.png']);


% Plot the results for the different sensors in one plot
% as well as in separate figures
%---------------------------------------------------------

% Create the colormap that we will use
Cmap = colormap(hot(256));
NoiseMax = max(noise_all);
NoiseMin = min(noise_all);

% Plot the final results as a scatter plot
DataLegends = {};
if(PlotSensor3)
    figure(2);
    h = plot(freq3, color3, 'bo','MarkerFaceColor','b'); hold on;
    DataLegends = {DataLegends{:},'Data: 3 colors'};
  
    figure;
    plot(freq3, color3, 'bo','MarkerFaceColor','b'); hold on;
    if(PlotBounds)
        plot([0 200],[DeltaE_Bounds3 ; DeltaE_Bounds3],'--r'); hold on;
        plot([MTF_Bounds3(1) MTF_Bounds3(1)] ,[0 20],'--r'); hold on;
        plot([MTF_Bounds3(2) MTF_Bounds3(2)] ,[0 20],'--r'); hold on;
    end
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bfColor Accuracy vs Frequency Accuracy, 3 sensors','FontSize',13);
    axis([0 1.1*max(freq_all) 0 1.1*max(color_all)]);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Raw_Data_3Senor_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Raw_Data_3Senor_' Version '.png']);
end    
if(PlotSensor4)
    figure(2);
    plot(freq4, color4, 'go','MarkerFaceColor','g'); hold on;
    DataLegends = {DataLegends{:},'Data: 4 colors'};
    
    figure;
    plot(freq4, color4, 'go','MarkerFaceColor','g'); hold on;
    if(PlotBounds)
        plot([0 200],[DeltaE_Bounds4 ; DeltaE_Bounds4],'--r'); hold on;
        plot([MTF_Bounds4(1) MTF_Bounds4(1)] ,[0 20],'--r'); hold on;
        plot([MTF_Bounds4(2) MTF_Bounds4(2)] ,[0 20],'--r'); hold on;
    end
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bfColor Accuracy vs Frequency Accuracy, 4 sensors','FontSize',13);
    axis([0 1.1*max(freq_all) 0 1.1*max(color_all)]);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Raw_Data_4Senor_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Raw_Data_4Senor_' Version '.png']);
end    
if(PlotSensor5)
    figure(2);
    plot(freq5, color5, 'ro','MarkerFaceColor','r'); hold on;
    DataLegends = {DataLegends{:},'Data: 5 colors'};

    figure;
    plot(freq5, color5, 'ro','MarkerFaceColor','r'); hold on;
    if(PlotBounds)
        plot([0 200],[DeltaE_Bounds5 ; DeltaE_Bounds5],'--r'); hold on;
        plot([MTF_Bounds5(1) MTF_Bounds5(1)] ,[0 20],'--r'); hold on;
        plot([MTF_Bounds5(2) MTF_Bounds5(2)] ,[0 20],'--r'); hold on;
    end
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bfColor Accuracy vs Frequency Accuracy, 5 sensors','FontSize',13);
    axis([0 1.1*max(freq_all) 0 1.1*max(color_all)]);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Raw_Data_5Senor_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Raw_Data_5Senor_' Version '.png']);
end
if(PlotSensor6)
    figure(2);
    plot(freq6, color6, 'co','MarkerFaceColor','c'); hold on;
    DataLegends = {DataLegends{:},'Data: 6 colors'};

    figure;
    plot(freq6, color6, 'co','MarkerFaceColor','c'); hold on;
    if(PlotBounds)
        plot([0 200],[DeltaE_Bounds6 ; DeltaE_Bounds6],'--r'); hold on;
        plot([MTF_Bounds6(1) MTF_Bounds6(1)] ,[0 20],'--r'); hold on;
        plot([MTF_Bounds6(2) MTF_Bounds6(2)] ,[0 20],'--r'); hold on;
    end
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bfColor Accuracy vs Frequency Accuracy, 6 sensors','FontSize',13);
    axis([0 1.1*max(freq_all) 0 1.1*max(color_all)]);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Raw_Data_6Senor_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Raw_Data_6Senor_' Version '.png']);
end
if(PlotSensor7)
    figure(2);
    plot(freq7, color7, 'ko','MarkerFaceColor','k'); hold on;
    DataLegends = {DataLegends{:},'Data: 7 colors'};
    
    figure;
    plot(freq7, color7, 'ko','MarkerFaceColor','k'); hold on;
    if(PlotBounds)
        plot([0 200],[DeltaE_Bounds7 ; DeltaE_Bounds7],'--r'); hold on;
        plot([MTF_Bounds7(1) MTF_Bounds7(1)] ,[0 20],'--r'); hold on;
        plot([MTF_Bounds7(2) MTF_Bounds7(2)] ,[0 20],'--r'); hold on;
    end
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bfColor Accuracy vs Frequency Accuracy, 7 sensors','FontSize',13);
    axis([0 1.1*max(freq_all) 0 1.1*max(color_all)]);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Raw_Data_7Senor_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Raw_Data_7Senor_' Version '.png']);
end

% Plot all these on one plot
figure(2);
xlabel('MTF-50','FontSize',12);
ylabel('Average \Delta E','FontSize',12);
title('\bfColor Accuracy vs Frequency Accuracy','FontSize',13);
legend(DataLegends,'FontSize',12);
axis([0 1.1*max(freq_all) 0 1.1*max(color_all)]);
set(gca,'FontSize',12);
grid on;

saveas(gcf, ['./Images/Raw_Data_AllSenors_' Version '.eps'],'epsc2');
saveas(gcf, ['./Images/Raw_Data_AllSenors_' Version '.png']);

% Plot each sensor's values separately with noise indicated
%-------------------------------------------------------------
MarkerSize = 50;

if(PlotSensor3);
    figure;
    scatter(freq3, color3, MarkerSize, noise3, 'o','filled'); hold on;
    colorbar;
    caxis([0 10]);
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bf 3 Color sensor simulation with noise','FontSize',13);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Noise_Data_3Senors_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Noise_Data_3Senors_' Version '.png']);
end

if(PlotSensor4);
    figure;
    scatter(freq4, color4, MarkerSize, noise4, 'o','filled'); hold on;
    colorbar;
    caxis([0 10]);
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bf 4 Color sensor simulation with noise','FontSize',13);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Noise_Data_4Senors_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Noise_Data_4Senors_' Version '.png']);
end

if(PlotSensor5);
    figure;
    scatter(freq5, color5, MarkerSize, noise5, 'o','filled'); hold on;
    colorbar;
    caxis([0 10]);
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bf 5 Color sensor simulation with noise','FontSize',13);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Noise_Data_5Senors_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Noise_Data_5Senors_' Version '.png']);
end

if(PlotSensor6);
    figure;
    scatter(freq6, color6, MarkerSize, noise6, 'o','filled'); hold on;
    colorbar;
    caxis([0 10]);
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bf 6 Color sensor simulation with noise','FontSize',13);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Noise_Data_6Senors_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Noise_Data_6Senors_' Version '.png']);
end

if(PlotSensor7);
    figure;
    scatter(freq7, color7, MarkerSize, noise7, 'o','filled'); hold on;
    colorbar;
    caxis([0 10]);
    xlabel('MTF-50','FontSize',12);
    ylabel('Average \Delta E','FontSize',12);
    title('\bf 7 Color sensor simulation with noise','FontSize',13);
    set(gca,'FontSize',12);
    grid on;
    
    saveas(gcf, ['./Images/Noise_Data_7Senors_' Version '.eps'],'epsc2');
    saveas(gcf, ['./Images/Noise_Data_7Senors_' Version '.png']);
end









